///////////////
// View List //
///////////////

#pragma once

#include "View Item.h"
#include "Subclass.h"
#include "Splash Screen.h"
#include <fstream.h>

class ViewList : public epp_Frame, public ContextMenu
{
    public:

        ViewList ();

        void Load (fstream&);
        void Save ();
        int NewCard (HWND, BOOL = TRUE);
        void ImportDeck (HWND, BOOL);
        void Add (ViewItem *);
        void Remove (ViewItem *);
        void Modify (int);
        void Delete (int);
        void Refresh (ViewItem *);
        ViewItem * Find (POINT&);
        void Enable (BOOL);
        BOOL Loaded ();

    private:

        BOOL LoadWindows (fstream&);
        void ImportCards ();
        void NewDeck ();
        void AllCards ();
        void FindCards ();
        void CloseAll ();
        void Help (BOOL);

        HMENU GetContextMenu ();
        ViewItem *GetCurView ();
        void SetRect ();

        void OnCommand (int, int id, HWND);
        int OnCompareItem (int, COMPAREITEMSTRUCT *);
        int OnCreate (CREATESTRUCT *);
        void OnDestroy ();
        void OnDrawItem (int, DRAWITEMSTRUCT *);
        BOOL OnEraseBkgnd (HDC);
        void OnMeasureItem (int, MEASUREITEMSTRUCT *);
        void OnMove (int, int);
        void OnSetFocus (HWND);
        void OnSize (int, int, int);
        void OnTimer (int);

		epp_ToolBar Toolbar;
        epp_ListBox List;
        SubList sList;
        epp_Font Font;
        epp_Menu Menu;

        epp_Timer _Timer;
        int _TimerCount;

        RECT _Rect;
        BOOL _Loaded;
        BOOL _Save;
        BOOL _Help;
        int Width;

    DECLARE_HANDLER
};

inline BOOL ViewList::Loaded ()
    { return _Loaded; }

extern ViewList Views;